package com.jonohennessy {
	import flash.events.*;
	import flash.net.*;
	
	public class HennessyModel {
		
		// Define the content modes
		public static const CONTENT_OPTICAL:int = 1;
		public static const CONTENT_SUNWEAR:int = 2;
		public static const CONTENT_PROMO:int = 3;
		public static const CONTENT_THESTORY:int = 4;
		public static const CONTENT_NEWS:int = 5;
		public static const CONTENT_AGENTS:int = 6;
		public static const CONTENT_CONTACT:int = 7;
		public static const CONTENT_MENU:int = 8;
		public static const CONTENT_NULL:int = 9;
		private var content_mode:int;
		private var animatingLock:Boolean = false;
		private var xml:XML;
		private var urlLoader:URLLoader;
		
		public function HennessyModel() {
			trace("model online");
			
			// Load the xml
			var urlRequest:URLRequest = new URLRequest("hennessy.xml");
			urlLoader = new URLLoader();
			urlLoader.addEventListener(Event.COMPLETE, xmlCompleteListener);
			urlLoader.load(urlRequest);
		}
		
		private function xmlCompleteListener(e:Event):void {
			xml = new XML(urlLoader.data);
			trace("model loaded xml");
			//testXML();
		}
		
		private function testXML():void {
			trace("looping through the glasses in optical");
			for each (var child:XML in xml.OPTICAL.*) {
				trace("child with model: " + child.@model + " and browser image url: " + child.@browserImage + " comes in a variety of colours:");
				for each (var colour:XML in child.*) {
					trace("colour id " + colour.@colourNumber + " thumb url: " + colour.THUMBNAIL + " full url: " + colour.LARGE);
				}
			}
		}
		
		public function getXML():XML {
			return xml;
		}
		
		// Invoked like: model.setMode(HennessyModel.CONTENT_NEWS)
		public function setMode(content_mode:int):void {
			this.content_mode = content_mode;
		}
		
		public function getMode():int {
			return content_mode;
		}
		
		public function getAnimatingLock():Boolean {
			return animatingLock;
		}
		
		public function setAnimatingLock(animatingLock:Boolean):void {
			this.animatingLock = animatingLock;
		}
	}
}